# -*- coding: UTF-8 -*-




import os
import globalVars
import globalPluginHandler
import addonHandler
from scriptHandler import script
import api
import config
import gui
import wx
from .settings import settingItems

addonHandler.initTranslation()
addonInstance = addonHandler.getCodeAddon()
addonName = addonInstance.name
addonSummary = addonInstance.manifest["summary"]
ra_exe = os.path.join(addonHandler.getCodeAddon().path, "RackAssistant", "RackAssistant.exe")
config.conf.spec[addonName] = {setting.configKey: setting.defaultValue for setting in settingItems}
raConf = config.conf[addonName]
if 'startafternvda' in raConf and raConf['startafternvda']:
	os.startfile(ra_exe)


class RackAssistantPanel(gui.settingsDialogs.SettingsPanel):
    title = addonSummary

    def makeSettings(self, sizer):
        self.config = config.conf[addonName]
        self.helper = gui.guiHelper.BoxSizerHelper(self, sizer=sizer)
        for setting in settingItems:
                widget = self.helper.addItem(wx.CheckBox(self, label=setting.label, name=setting.configKey))
                widget.SetValue(self.config[setting.configKey])

    def onSave(self):
        for child in self.helper.sizer.GetChildren():
            widget = child.GetWindow()
            if isinstance(widget, wx.CheckBox):
                self.config[widget.Name] = widget.IsChecked()

class GlobalPlugin(globalPluginHandler.GlobalPlugin):
	def __init__(self):
		super(GlobalPlugin, self).__init__()
		if not globalVars.appArgs.secure:
			gui.settingsDialogs.NVDASettingsDialog.categoryClasses.append(RackAssistantPanel)

	def terminate(self):
		super(GlobalPlugin, self).terminate()
		if not globalVars.appArgs.secure:
			gui.settingsDialogs.NVDASettingsDialog.categoryClasses.remove(RackAssistantPanel)

	@script(
		description=_("启动机架助手"),
		category=addonSummary,
	)
	def script_open_ra(self, gesture):
		os.startfile(ra_exe)
